/****** Object:  View [dbo].[V_ANALISE_CONTAS_PAGAR_COMPRADOR_ANALITICO]    Script Date: 07/04/2013 16:57:47 ******/
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_ANALISE_CONTAS_PAGAR_COMPRADOR_ANALITICO]'))
DROP VIEW [dbo].[V_ANALISE_CONTAS_PAGAR_COMPRADOR_ANALITICO]
GO
/*
SELECT 
	*
FROM 
	V_ANALISE_CONTAS_PAGAR_COMPRADOR_ANALITICO 
WHERE 
	CD_EMP =1 
	AND ANO=2019 
	AND MES = 12
*/
CREATE VIEW V_ANALISE_CONTAS_PAGAR_COMPRADOR_ANALITICO
WITH ENCRYPTION
AS
SELECT
	CPL.CD_EMP,
	CPL.CD_FILIAL,
	YEAR(cpl.DT_VENCTO) AS ANO,
	MONTH(cpl.DT_VENCTO) AS MES,
	cpl.DT_VENCTO,
	e.CD_COMPRADOR,
	EST_COMPRADOR.NM_COMPRADOR,
	PG_FORN.RZ_FORN,
	PG_FORN.NM_FANT,
	PG_TP_FORN.DS_TP, 
	cpl.VLR_DP AS VLR_DUPLICATA,
	cpl.VLR_DESC AS VLR_DESC,
	cpl.VLR_JUROS AS VLR_JUROS,
	cpl.VLR_DESP_OUTR AS VLR_DESP_OUTR,
	cpl.VLR_DEVOLUCAO AS VLR_DEVOLUCAO,
	(cpl.VLR_DP + cpl.VLR_JUROS + cpl.VLR_DESP_OUTR)-(cpl.VLR_DESC+cpl.VLR_DEVOLUCAO) AS VLR_DUPLICATA_LIQUIDO,
	PG_TP_FORN.TP_FORN,
	V_TP_FORN_CLASSIFICACAO.CLASSIFICACAO,
	CPL.CD_PROD,
	FAB.CD_FABRIC, 
	FAB.NM_FABRIC, 
	L.CD_ARV_MERC_LINHA, 
	L.DS_ARV_MERC_LINHA,
	PG_CRED.NR_DP,
	PG_CRED.PARC,
	EST_PROD.DS_PROD,
	PG_FORN.CD_FORN,
	cpl.VLR_IMP,
	0 AS VLR_VENDA,
	'CONTAS A PAGAR' AS TIPO_TRANSACAO,
	CPL.VLR_DUP_PGTO
FROM
	EST_COMPRADOR_MOVIMENTACAO e INNER JOIN EST_COMPRADOR_MOVIMENTACAO_CPL cpl ON
	e.CD_CTR = cpl.CD_CTR
	INNER JOIN EST_COMPRADOR ON
	e.CD_EMP  = EST_COMPRADOR.CD_EMP AND 
	e.CD_COMPRADOR = EST_COMPRADOR.CD_COMPRADOR 
	INNER JOIN EST_PROD ON 
	cpl.CD_EMP = EST_PROD.CD_EMP AND
	cpl.CD_PROD = EST_PROD.CD_PROD 
	INNER JOIN PG_TP_FORN ON
	cpl.CD_TP_FORN = PG_TP_FORN.CD_TP_FORN
	INNER JOIN V_TP_FORN_CLASSIFICACAO ON
	PG_TP_FORN.TP_FORN = V_TP_FORN_CLASSIFICACAO.TP_FORN
	INNER JOIN PG_FORN ON
	cpl.CD_EMP = PG_FORN.CD_EMP AND
	cpl.CD_FORN = PG_FORN.CD_FORN
	INNER JOIN	dbo.EST_PROD_EST_ARV_MERCADOLOGICA AS ARV ON 
	cpl.CD_EMP = ARV.CD_EMP AND 
	cpl.CD_PROD = ARV.CD_PROD 
	INNER JOIN dbo.EST_PROD_FABRIC AS FAB ON 
	EST_PROD.CD_FABRIC = FAB.CD_FABRIC 
	INNER JOIN	dbo.EST_ARV_MERC_LINHA AS L ON 
	ARV.CD_EMP = L.CD_EMP AND 
	ARV.CD_ARV_MERC_LINHA = L.CD_ARV_MERC_LINHA 
	INNER JOIN PG_CRED ON
	cpl.CD_EMP = PG_CRED.CD_EMP AND
	cpl.CD_FILIAL = PG_CRED.CD_FILIAL AND
	cpl.CD_PG_CRED = PG_CRED.CD_PG_CRED
WHERE
	CPL.TIPO_TRANSACAO=0
/*UNION ALL
SELECT
	CPL.CD_EMP,
	CPL.CD_FILIAL,
	YEAR(cpl.DT_VENCTO) AS ANO,
	MONTH(cpl.DT_VENCTO) AS MES,
	cpl.DT_VENCTO,
	e.CD_COMPRADOR,
	EST_COMPRADOR.NM_COMPRADOR,
	'VENDAS',
	'VENDAS',
	'VENDAS', 
	0 AS VLR_DUPLICATA,
	0 AS VLR_DESC,
	0 AS VLR_JUROS,
	0 AS VLR_DESP_OUTR,
	0 AS VLR_DEVOLUCAO,
	0 AS VLR_DUPLICATA_LIQUIDO,
	0 AS TP_FORN,
	'VENDAS ' AS CLASSIFICACAO,
	CPL.CD_PROD,
	FAB.CD_FABRIC, 
	FAB.NM_FABRIC, 
	L.CD_ARV_MERC_LINHA, 
	L.DS_ARV_MERC_LINHA,
	0 AS NR_DP,
	0 AS PARC,
	EST_PROD.DS_PROD,
	0 AS CD_FORN,
	cpl.VLR_IMP,
	cpl.VLR_DP AS VLR_VENDA,
	'VENDAS' AS TIPO_TRANSACAO,
	0 AS VLR_DUP_PGTO
FROM
	EST_COMPRADOR_MOVIMENTACAO e INNER JOIN EST_COMPRADOR_MOVIMENTACAO_CPL cpl ON
	e.CD_CTR = cpl.CD_CTR
	INNER JOIN EST_COMPRADOR ON
	e.CD_EMP  = EST_COMPRADOR.CD_EMP AND 
	e.CD_COMPRADOR = EST_COMPRADOR.CD_COMPRADOR 
	INNER JOIN EST_PROD ON 
	cpl.CD_EMP = EST_PROD.CD_EMP AND
	cpl.CD_PROD = EST_PROD.CD_PROD 
	INNER JOIN	dbo.EST_PROD_EST_ARV_MERCADOLOGICA AS ARV ON 
	cpl.CD_EMP = ARV.CD_EMP AND 
	cpl.CD_PROD = ARV.CD_PROD 
	INNER JOIN dbo.EST_PROD_FABRIC AS FAB ON 
	EST_PROD.CD_FABRIC = FAB.CD_FABRIC 
	INNER JOIN	dbo.EST_ARV_MERC_LINHA AS L ON 
	ARV.CD_EMP = L.CD_EMP AND 
	ARV.CD_ARV_MERC_LINHA = L.CD_ARV_MERC_LINHA 
WHERE
	CPL.TIPO_TRANSACAO=1*/
UNION ALL
	SELECT
		P.CD_EMP,
		P.CD_FILIAL,
		YEAR(DATEADD(DAY,ISNULL(C.DIAS_VENCTO,20), ISNULL(P.DT_FATURAMENTO,P.DT_EMI))) AS ANO,
		MONTH(DATEADD(DAY,ISNULL(C.DIAS_VENCTO,20), ISNULL(P.DT_FATURAMENTO,P.DT_EMI))) AS MES,
		DATEADD(DAY,ISNULL(C.DIAS_VENCTO,20), ISNULL(P.DT_FATURAMENTO,P.DT_EMI)),
		ITCP.CD_COMPRADOR,
		EST_COMPRADOR.NM_COMPRADOR,
		PG_FORN.RZ_FORN,
		PG_FORN.NM_FANT,
		PG_TP_FORN.DS_TP,
		(CONVERT (MONEY, ((it.VLR_IT - (it.VLR_IT * (it.PERC_DESC/100.0000000))))+it.VLR_ICMS_SUBS)   * it.QT_IT) / CASE WHEN ISNULL(c.QT_PARC,1)=0 THEN 1 ELSE ISNULL(c.QT_PARC,1) END  VLR_PEDIDO_PENDENTE,
		0 AS VLR_DESC,
		0 AS VLR_JUROS,
		0 AS VLR_DESP_OUTR,
		0 AS VLR_DEVOLUCAO,
		(CONVERT (MONEY, ((it.VLR_IT - (it.VLR_IT * (it.PERC_DESC/100.0000000))))+it.VLR_ICMS_SUBS)  * it.QT_IT) / CASE WHEN ISNULL(c.QT_PARC,1)=0 THEN 1 ELSE ISNULL(c.QT_PARC,1) END  VLR_PEDIDO_PENDENTE,		
		PG_TP_FORN.TP_FORN,
		V_TP_FORN_CLASSIFICACAO.CLASSIFICACAO, 
		IT.CD_PROD,
		FAB.CD_FABRIC, 
		FAB.NM_FABRIC, 
		L.CD_ARV_MERC_LINHA, 
		L.DS_ARV_MERC_LINHA,
		P.CD_PED,
		C.NR_VENCTO  AS PARC,
		EST_PROD.DS_PROD,
		PG_FORN.CD_FORN,
		0 AS VLR_IMP,
		0 AS VLR_VENDA,
		'PEDIDO COMPRAS PENDENTE' AS TRANSACAO,
		0 AS VLR_DUP_PGTO
	FROM 
		EST_PED_CP P LEFT OUTER JOIN V_GLB_COND_PGTO_CPL C ON  
		P.CD_COND_PGTO = C.CD_COND_PGTO
		INNER JOIN EST_PED_CP_PENDENCIA pend ON  
		P.CD_EMP  = pend.CD_EMP AND 
		P.CD_FILIAL  = pend.CD_FILIAL AND 
		P.CD_PED  = pend.CD_PED
		INNER JOIN EST_PED_CP_IT it ON  
		P.CD_EMP  = it.CD_EMP AND 
		P.CD_FILIAL  = it.CD_FILIAL AND 
		P.CD_PED  = it.CD_PED
		INNER JOIN EST_PED_CP_IT_COMPRADOR ITCP ON  
		it.CD_EMP  = ITCP.CD_EMP AND 
		it.CD_FILIAL  = ITCP.CD_FILIAL AND 
		it.CD_PED  = ITCP.CD_PED AND
		it.CD_PROD  = ITCP.CD_PROD
		INNER JOIN PG_FORN ON
		P.CD_EMP = PG_FORN.CD_EMP AND
		P.CD_FORN = PG_FORN.CD_FORN 
		INNER JOIN PG_TP_FORN ON
		PG_FORN.CD_TP_FORN = PG_TP_FORN.CD_TP_FORN 
		INNER JOIN V_TP_FORN_CLASSIFICACAO ON
		PG_TP_FORN.TP_FORN = V_TP_FORN_CLASSIFICACAO.TP_FORN
		INNER JOIN EST_PROD ON 
		it.CD_EMP = EST_PROD.CD_EMP AND
		it.CD_PROD = EST_PROD.CD_PROD 
		INNER JOIN	dbo.EST_PROD_EST_ARV_MERCADOLOGICA AS ARV ON 
		it.CD_EMP = ARV.CD_EMP AND 
		it.CD_PROD = ARV.CD_PROD 
		INNER JOIN dbo.EST_PROD_FABRIC AS FAB ON 
		EST_PROD.CD_FABRIC = FAB.CD_FABRIC 
		INNER JOIN	dbo.EST_ARV_MERC_LINHA AS L ON 
		ARV.CD_EMP = L.CD_EMP AND 
		ARV.CD_ARV_MERC_LINHA = L.CD_ARV_MERC_LINHA 
		INNER JOIN EST_COMPRADOR ON
		ITCP.CD_EMP  = EST_COMPRADOR.CD_EMP AND 
		ITCP.CD_COMPRADOR = EST_COMPRADOR.CD_COMPRADOR